#pragma once


#include "Quaternion.h"


Quaternion GetRotationToLocation(Vector3 targetLocation, float y_bias, Vector3 myLoc){
    return Quaternion::LookRotation((targetLocation + Vector3(0, y_bias, 0)) - myLoc, Vector3(0, 1, 0));
}

template <typename T>
struct monoArray
{
    void* klass;
    void* monitor;
    void* bounds;
    int   max_length;
    void* vector [1];
    int getLength()
    {
        return max_length;
    }
    T getPointer()
    {
        return (T)vector;
    }
};

template <typename T>
struct monoList {
    void *unk0;
    void *unk1;
    monoArray<T> *items;
    int size;
    int version;

    T getItems(){
        return items->getPointer();
    }

    int getSize(){
        return size;
    }

    int getVersion(){
        return version;
    }
};

template <typename K, typename V>
struct monoDictionary {
    void *unk0;
    void *unk1;
    monoArray<int **> *table;
    monoArray<void **> *linkSlots;
    monoArray<K> *keys;
    monoArray<V> *values;
    int touchedSlots;
    int emptySlot;
    int size;

    K getKeys(){
        return keys->getPointer();
    }

    V getValues(){
        return values->getPointer();
    }

    int getNumKeys(){
        return keys->getLength();
    }

    int getNumValues(){
        return values->getLength();
    }

    int getSize(){
        return size;
    }
};
union intfloat {
    int i;
    float f;
};

typedef struct _monoString
{
    void* klass;
    void* monitor;
    int length;    
    char chars[1];   
    int getLength()
    {
      return length;
    }
    char* getChars()
    {
        return chars;
    }
}monoString;

class ExpireDate {
    public:
    ExpireDate() {
        std::time_t now = std::time(nullptr);
        expirationTime = std::chrono::system_clock::from_time_t(now);
    }
    void setExpirationDate(int day, int month, int year) {
        std::tm tm_struct = {};
        tm_struct.tm_mday = day;
        tm_struct.tm_mon = month - 1;
        tm_struct.tm_year = year - 1900;
        std::time_t expirationTime_t = std::mktime(&tm_struct);
        expirationTime = std::chrono::system_clock::from_time_t(expirationTime_t);
    }
    bool isExpired() {
        std::chrono::system_clock::time_point now = std::chrono::system_clock::now();
        return now >= expirationTime;
    }
    private:
    std::chrono::system_clock::time_point expirationTime;
};
